/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api;

import com.agricraft.agricraft.api.adapter.AgriAdapter;
import com.agricraft.agricraft.api.adapter.AgriAdapters;
import com.agricraft.agricraft.api.codecs.AgriMutation;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.fertilizer.AgriFertilizer;
import com.agricraft.agricraft.api.genetic.AgriGeneRegistry;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.genetic.AgriMutationHandler;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.plant.AgriWeed;
import com.agricraft.agricraft.api.requirement.AgriGrowthConditionRegistry;
import com.agricraft.agricraft.api.requirement.SeasonLogic;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.common.util.Platform;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;

public final class AgriApi {
    public static final String MOD_ID = "agricraft";
    public static final class_5321<class_2378<AgriPlant>> AGRIPLANTS = class_5321.method_29180((class_2960)new class_2960("agricraft", "plants"));
    public static final class_5321<class_2378<AgriWeed>> AGRIWEEDS = class_5321.method_29180((class_2960)new class_2960("agricraft", "weeds"));
    public static final class_5321<class_2378<AgriSoil>> AGRISOILS = class_5321.method_29180((class_2960)new class_2960("agricraft", "soils"));
    public static final class_5321<class_2378<AgriMutation>> AGRIMUTATIONS = class_5321.method_29180((class_2960)new class_2960("agricraft", "mutations"));
    public static final class_5321<class_2378<AgriFertilizer>> AGRIFERTILIZERS = class_5321.method_29180((class_2960)new class_2960("agricraft", "fertilizers"));

    public static Optional<class_2378<AgriPlant>> getPlantRegistry() {
        return Platform.get().getRegistry(AGRIPLANTS);
    }

    public static Optional<class_2378<AgriPlant>> getPlantRegistry(class_5455 registryAccess) {
        return registryAccess.method_33310(AGRIPLANTS);
    }

    public static Optional<class_2960> getPlantId(AgriPlant plant) {
        return AgriApi.getPlantRegistry().map(registry -> registry.method_10221((Object)plant));
    }

    public static Optional<class_2960> getPlantId(AgriPlant plant, class_5455 registryAccess) {
        return AgriApi.getPlantRegistry(registryAccess).map(registry -> registry.method_10221((Object)plant));
    }

    public static Optional<AgriPlant> getPlant(String plantId) {
        return AgriApi.getPlant(new class_2960(plantId));
    }

    public static Optional<AgriPlant> getPlant(class_2960 plantId) {
        return AgriApi.getPlantRegistry().map(registry -> (AgriPlant)registry.method_10223(plantId));
    }

    public static Optional<AgriPlant> getPlant(String plantId, class_5455 registryAccess) {
        return AgriApi.getPlant(new class_2960(plantId), registryAccess);
    }

    public static Optional<AgriPlant> getPlant(class_2960 plantId, class_5455 registryAccess) {
        return AgriApi.getPlantRegistry(registryAccess).map(registry -> (AgriPlant)registry.method_10223(plantId));
    }

    public static Optional<class_2378<AgriWeed>> getWeedRegistry() {
        return Platform.get().getRegistry(AGRIWEEDS);
    }

    public static Optional<class_2378<AgriWeed>> getWeedRegistry(class_5455 registryAccess) {
        return registryAccess.method_33310(AGRIWEEDS);
    }

    public static Optional<AgriWeed> getWeed(String weedId) {
        return AgriApi.getWeed(new class_2960(weedId));
    }

    public static Optional<AgriWeed> getWeed(class_2960 weedId) {
        return AgriApi.getWeedRegistry().map(registry -> (AgriWeed)registry.method_10223(weedId));
    }

    public static Optional<AgriWeed> getWeed(String weedId, class_5455 registryAccess) {
        return AgriApi.getWeed(new class_2960(weedId), registryAccess);
    }

    public static Optional<AgriWeed> getWeed(class_2960 weedId, class_5455 registryAccess) {
        return AgriApi.getWeedRegistry(registryAccess).map(registry -> (AgriWeed)registry.method_10223(weedId));
    }

    public static Optional<class_2378<AgriSoil>> getSoilRegistry() {
        return Platform.get().getRegistry(AGRISOILS);
    }

    public static Optional<class_2378<AgriSoil>> getSoilRegistry(class_5455 registryAccess) {
        return registryAccess.method_33310(AGRISOILS);
    }

    public static Optional<class_2960> getSoilId(AgriSoil soil) {
        return AgriApi.getSoilRegistry().map(registry -> registry.method_10221((Object)soil));
    }

    public static Optional<class_2960> getSoilId(AgriSoil soil, class_5455 registryAccess) {
        return AgriApi.getSoilRegistry(registryAccess).map(registry -> registry.method_10221((Object)soil));
    }

    public static Optional<AgriSoil> getSoil(class_1937 level, class_2338 pos) {
        return AgriApi.getSoil(AgriApi.getSoilRegistry(level.method_30349()), (class_1922)level, pos);
    }

    public static Optional<AgriSoil> getSoil(class_1922 level, class_2338 pos) {
        return AgriApi.getSoil(AgriApi.getSoilRegistry(), level, pos);
    }

    public static Optional<AgriSoil> getSoil(class_1922 level, class_2338 pos, class_5455 registryAccess) {
        return AgriApi.getSoil(AgriApi.getSoilRegistry(registryAccess), level, pos);
    }

    private static Optional<AgriSoil> getSoil(Optional<class_2378<AgriSoil>> optionalRegistry, class_1922 level, class_2338 pos) {
        if (optionalRegistry.isEmpty()) {
            return Optional.empty();
        }
        class_2680 blockState = level.method_8320(pos);
        return optionalRegistry.get().method_10220().filter(soil -> soil.isVariant(blockState)).findFirst();
    }

    public static Optional<class_2378<AgriMutation>> getMutationRegistry() {
        return Platform.get().getRegistry(AGRIMUTATIONS);
    }

    public static Optional<class_2378<AgriMutation>> getMutationRegistry(class_5455 registryAccess) {
        return registryAccess.method_33310(AGRIMUTATIONS);
    }

    public static Stream<AgriMutation> getMutationsFromParents(String parent1, String parent2) {
        return AgriApi.getMutationRegistry().map(registry -> registry.method_10220().filter(mutation -> {
            String p1 = mutation.parent1().toString();
            String p2 = mutation.parent2().toString();
            return p1.equals(parent1) && p2.equals(parent2) || p1.equals(parent2) && p2.equals(parent1);
        })).orElse(Stream.empty());
    }

    public static AgriMutationHandler getMutationHandler() {
        return AgriMutationHandler.getInstance();
    }

    public static Optional<class_2378<AgriFertilizer>> getFertilizerRegistry() {
        return Platform.get().getRegistry(AGRIFERTILIZERS);
    }

    public static Optional<class_2378<AgriFertilizer>> getFertilizerRegistry(class_5455 registryAccess) {
        return registryAccess.method_33310(AGRIFERTILIZERS);
    }

    public static Optional<AgriFertilizer> getFertilizer(class_1799 stack) {
        return AgriApi.getFertilizerAdapter(stack).flatMap(adapter -> adapter.valueOf(stack));
    }

    public static Optional<AgriAdapter<AgriFertilizer>> getFertilizerAdapter(Object obj) {
        return AgriAdapters.FERTILIZER_ADAPTERS.stream().filter(adapter -> adapter.accepts(obj)).findFirst();
    }

    public static AgriGeneRegistry getGeneRegistry() {
        return AgriGeneRegistry.getInstance();
    }

    public static AgriStatRegistry getStatRegistry() {
        return AgriStatRegistry.getInstance();
    }

    public static Optional<AgriCrop> getCrop(class_1922 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof AgriCrop) {
            AgriCrop crop = (AgriCrop)blockEntity;
            return Optional.of(crop);
        }
        return Optional.empty();
    }

    public static AgriGrowthConditionRegistry getGrowthConditionRegistry() {
        return AgriGrowthConditionRegistry.getInstance();
    }

    public static Optional<AgriAdapter<AgriGenome>> getGenomeAdapter(Object obj) {
        return AgriAdapters.GENOME_ADAPTERS.stream().filter(adapter -> adapter.accepts(obj)).findFirst();
    }

    public static SeasonLogic getSeasonLogic() {
        return SeasonLogic.INSTANCE;
    }
}

